% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{plot_residuals}
\alias{plot_residuals}
\title{Plot the residuals}
\usage{
plot_residuals(train_output, col)
}
\arguments{
\item{train_output}{Training output, can be the output of WA-PLS, WA-PLS with
\code{fx} correction, TWA-PLS, or TWA-PLS with \code{fx} correction}

\item{col}{Choose which column of the fitted value to plot, in other words,
how many number of components you want to use.}
}
\value{
Plotting status.
}
\description{
Plot the residuals, the black line is 0 line, the red line is the locally
estimated scatterplot smoothing, which shows the degree of local
compression.
}
\examples{
\dontrun{
# Load modern pollen data
modern_pollen <- read.csv("/path/to/modern_pollen.csv")

# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "taxa0")
taxaColMax <- which(colnames(modern_pollen) == "taxaN")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

fit_tf_Tmin2 <- fxTWAPLS::TWAPLS.w2(
  taxa,
  modern_pollen$Tmin,
  nPLS = 5,
  usefx = TRUE,
  fx_method = "bin",
  bin = 0.02
)

nsig <- 3 # This should be got from the random t-test of the cross validation
fxTWAPLS::plot_residuals(fit_tf_Tmin2, nsig)
}

}
\seealso{
\code{\link{TWAPLS.w}} and \code{\link{WAPLS.w}}
}
