% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning_parameters.R
\name{WGCNA_control}
\alias{WGCNA_control}
\title{Set Parameters for WGCNA Step of
Fuzzy Forests}
\usage{
WGCNA_control(power = 6, ...)
}
\arguments{
\item{power}{Power of adjacency function.}

\item{...}{Additional arguments.
See blockwiseModules from the WGCNA package for
details.}
}
\value{
An object of type WGCNA_control.
}
\description{
Creates \code{WGCNA_control} object for
controlling WGCNA will be carried out.
}
\note{
This work was partially funded by NSF IIS 1251151.
}
\examples{
WGCNA_params <- WGCNA_control(p=7, minModuleSize=30, TOMType = "unsigned",
                              reassignThreshold = 0, mergeCutHeight = 0.25,
                              numericLabels = TRUE, pamRespectsDendro = FALSE)
}
\references{
Conn, D., Ngun, T., Ramirez C.M., Li, G. (2019).
"Fuzzy Forests: Extending Random Forest Feature Selection for Correlated, High-Dimensional Data."
\emph{Journal of Statistical Software}, \strong{91}(9).
\doi{doi:10.18637/jss.v091.i09}

Zhang, B. and Horvath, S. (2005).
"A General Framework for Weighted Gene Co-Expression Network Analysis."
\emph{Statistical Applications in Genetics and Molecular Biology}, \strong{4}(1).
\doi{doi:10.2202/1544-6115.1128}
}
