% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparation.R
\name{buildStructureModels}
\alias{buildStructureModels}
\title{Generate list of file structure}
\usage{
buildStructureModels(modelName, experiments, dataFolder, coordinateFilenames,
  tasFilenames, timeFilenames, dataDirectories)
}
\arguments{
\item{modelName}{Character string of climate model name (e.g., "bcc1"). This
name is generated from the subdirectory name for the climate model within
\code{dataFolder}.}

\item{experiments}{Character string of the experiment(s). Possible variables
are the names of elements in the list object specified by the
\code{dataDirectories} argument in \code{\link{gen_hw_set}}.}

\item{dataFolder}{Character string with pathway to a directory with
climate projection data. This directory must have a specific structure--
see the \code{futureheatwaves} vignette for guidance on setting up this
directory.}

\item{coordinateFilenames}{Character string the with filename of each
grid point location file. This filename should be identical for all
ensemble member subdirectories included in the \code{dataFolder} directory.
See the package vignette for an example of the required structure for this
file.}

\item{tasFilenames}{Character string the with filename of each climate
projection file. This filename should be identical for all ensemble
member subdirectories included in the \code{dataFolder} directory. See the
package vignette for an example of the required structure for this file.}

\item{timeFilenames}{Character string the with filename of each projection
dates file. This filename should be identical for all ensemble
member  subdirectories included in the \code{dataFolder} directory. See
the package vignette for an example of the required structure for this
file.}

\item{dataDirectories}{A list object, with two elements, one for each of the
two subdirectories included in the main directory. Typically, these will
be separate directories of historical and projection experiments from
climate models. Each element of the list should be named with the name of
the subdirectory and should provide a numeric vector with the starting and
ending years of the data within each of the two subdirectories (e.g.,
\code{list("historical" = c(1990, 1999), "rcp85" = c(2060, 2079))}
for a \code{dataFolder} with historical experiment data for 1990 to 1999
and RCP8.5 projections for 2060 to 2079).}
}
\value{
A list of length 3. The first element is the name of the model
   whose structure was being built. The second element is, for this climate
   model, the hierarchy of the first subdirectory specified by
   \code{dataDirectories}. The third element is the hierarchy of the second
   subdirectory specified by \code{dataDirectories}. The second and third
   elements are return values of \code{\link{buildStructureExperiments}}.
}
\description{
This function takes input from \code{\link{acquireDirectoryStructure}} and
uses it to generate a list object with the projection directory
file structure. This parsed file structure is later used to lead other
code through all climate models and ensemble members in the input
projection directory.
}

