% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionLogo.R
\name{fusionLogo}
\alias{fusionLogo}
\title{Adding FusionCharts logo}
\usage{
fusionLogo(
  fusionPlot,
  logoURL = "NULL",
  logoAlpha = "40",
  logoScale = "80",
  logoPosition = c("TL", "TR", "BL", "BR", "CC"),
  logoLink = NULL
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{logoURL}{Specify the URL of the external logo}

\item{logoAlpha}{Set the transparency of the external logo}

\item{logoScale}{Set the scale of the external logo (0 to 300)}

\item{logoPosition}{Specify the position of the external logo}

\item{logoLink}{Add an external link to the external logo}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/loading-external-logo}
}
\examples{
library(fusionchartsR)
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260,180, 115))
logoURL <- "https://static.fusioncharts.com/sampledata/images/Logo-HM-72x72.png"
df \%>\%
fusionPlot(x = "label", y = "value", type = "doughnut2d") \%>\%
fusionLogo(logoURL = logoURL) \%>\%
fusionTheme(theme = "fusion")

}
