% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionCanvas.R
\name{fusionCanvas}
\alias{fusionCanvas}
\title{Adding FusionCharts canvas}
\usage{
fusionCanvas(
  fusionPlot,
  showCanvasBg = FALSE,
  canvasbgColorFirst = "#5a5a5a",
  canvasbgColorSecond = NULL,
  canvasBgDepth = "0",
  canvasbgAlpha = "100",
  canvasBgRatioStart = "40",
  canvasBgRatioEnd = "60",
  canvasBgAngle = "0",
  showCanvasBorder = FALSE,
  canvasBorderColor = "#666666",
  canvasBorderAlpha = "80",
  canvasBorderThickness = "1",
  showCanvasBase = FALSE,
  canvasBaseDepth = "5",
  canvasBaseColor = "#aaaaaa"
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{showCanvasBg}{Show the canvas background}

\item{canvasbgColorFirst}{Specify the hex code of the first canvas background color}

\item{canvasbgColorSecond}{Specify the hex code of the second canvas background color}

\item{canvasBgDepth}{Set the depth of the canvas background}

\item{canvasbgAlpha}{Set the transparency of the background color}

\item{canvasBgRatioStart}{Set the first value of the canvas background ratio (in percentage)}

\item{canvasBgRatioEnd}{Set the second value of the canvas background ratio (in percentage)}

\item{canvasBgAngle}{Specify canvas background angle (in degrees)}

\item{showCanvasBorder}{Show the canvas border}

\item{canvasBorderColor}{Set the border color}

\item{canvasBorderAlpha}{Set the transparency of the border}

\item{canvasBorderThickness}{Set the thickness of the border}

\item{showCanvasBase}{Show the canvas base}

\item{canvasBaseDepth}{Set the height of the canvas base}

\item{canvasBaseColor}{Specify the hex code of the base color}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/canvas}
}
\examples{
library(fusionchartsR)
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260,180, 115))
df \%>\%
fusionPlot(x = "label", y = "value", type = "column2d") \%>\%
fusionCanvas(showCanvasBorder = TRUE, canvasBorderThickness = "4", canvasBorderAlpha = "80") \%>\%
fusionTheme(theme = "fusion")

}
