% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainingFunctions.R
\name{fusemlr}
\alias{fusemlr}
\title{fusemlr}
\usage{
fusemlr(
  training,
  ind_subset = NULL,
  use_var_sel = FALSE,
  resampling_method = NULL,
  resampling_arg = list(),
  seed = NULL
)
}
\arguments{
\item{training}{\code{Training} \cr
Training object for storing training layers.}

\item{ind_subset}{\code{vector} \cr
ID subset to be used for training.}

\item{use_var_sel}{\code{boolean} \cr
If \code{TRUE} and no variable selection has been performed for the provide training object,
then a variable selection will proceed the training.
Otherwise, if variable selection has been previously performed, the selected variables will be used for training.}

\item{resampling_method}{\code{function} \cr
Function for internal validation. If not specify, the \code{resampling} function
from the package \code{caret} is used for a 10-folds cross-validation.}

\item{resampling_arg}{\code{list} \cr
List of arguments to be passed to the function.}

\item{seed}{\code{integer} \cr
Random seed used for resampling. Default is NULL, which generates the seed from \code{R}.}
}
\value{
The current object is returned, with each learner trained on each layer.
}
\description{
Trains the \link{Training} object passed as argument. A training object must contain
the training layers and a training meta-layer. A training layer encapsulates
data modalities, a variable selection method and a learner. Use the function
\link{createTraining} to create a training object, \link{createTrainLayer} to add training
layers to the created training object, and \link{createTrainMetaLayer} to add a meta-layer
with the corresponding meta-learner to the training object. The function \code{fusemlr}
is designed to train all training layers and the meta-learner. After training
the layer-specific base models and the meta-model will be stored in the training
object which can be used for predictions.
}
\references{
Fouodo C.J.K, Bleskina M. and Szymczak S. (2024). fuseMLR: An R package for integrative prediction modeling of multi-omics data, paper submitted.
}
\seealso{
\link{createTrainLayer}, \link{createTrainMetaLayer}, \link{extractModel} and \link{extractData}.
}
