% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FunEigen.r
\name{funeigen}
\alias{funeigen}
\title{Perform eigenfunction decomposition on functional covariate}
\usage{
funeigen(id, time, x, num.bins = 35, preferred.num.eigenfunctions = 30)
}
\arguments{
\item{id}{A vector of subject ID's.}

\item{time}{A vector of measurement times.}

\item{x}{A single functional predictor represented as a vector or a one-column matrix.}

\item{num.bins}{The number of knots used in the spline basis for the
beta function. The default is based on the  Goldsmith et al. (2011)
sample code.}

\item{preferred.num.eigenfunctions}{The number of eigenfunctions to use in approximating the
covariance function of x (see Goldsmith et al., 2011)}
}
\description{
A function to do the eigenfunction decomposition
as part of a penalized functional regression as in Goldsmith et al. (2011)
}
\note{
The algorithm for this function follows that of "sparse_simulation.R", which was
written on Nov. 13, 2009, by Jeff Goldsmith; Goldsmith noted that he used some code from Chongzhi Di for the part about
handling sparsity.  "sparse_simulation.R" was part of the supplementary material for
Goldsmith, Bobb, Crainiceanu, Caffo, and Reich (2011).  The  sample code can be
   found at \url{http://www.jeffgoldsmith.com/Downloads/PFR_Code.zip}.
The \code{num.bins} parameter corresponds to  \code{N.fit} in Goldsmith et al, \code{sparse_simulation.R} and
\code{preferred.num.eigenfunctions} corresponds to \code{Kz} in Goldsmith et al.
}
\references{
Goldsmith, J., Bobb, J., Crainiceanu, C. M., Caffo, B., and Reich, D.
   (2011). Penalized functional regression. Journal of Computational
   and Graphical Statistics, 20(4), 830-851. DOI: 10.1198/jcgs.2010.10007.
}
\seealso{
\code{\link{fitted.funeigen}}, \code{link{plot.funeigen}}
}

