% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_funnel.R
\name{funnel_step}
\alias{funnel_step}
\alias{funnel_steps}
\title{Continue to funnel}
\usage{
funnel_step(tbl, moment_type, type, name = moment_type, optional = FALSE, ...)

funnel_steps(tbl, moment_types, type, ...)
}
\arguments{
\item{tbl}{A table of different moments and timestamps}

\item{moment_type}{The next moment in the funnel}

\item{type}{The type of after_join (e.g. "first-first", "any-any")}

\item{name}{If you want a custom name instead of the moment_type; needed if the moment type is already in the sequence}

\item{optional}{Whether this step in the funnel should be optional. If so, the following step will also try joining
in a way that skips this step. Note that multiple optional steps in a row aren't supported.}

\item{...}{Extra arguments passed on to \link{after_left_join}. For \code{funnel_steps}, these are passed on to \code{funnel_step}.}

\item{moment_types}{For \code{funnel_steps}, a character vector of
moment types, which are applied in order}
}
\description{
Continue to funnel
}
\examples{

library(dplyr)

activity <- tibble::tribble(
  ~ "user_id", ~ "event", ~ "timestamp",
  1, "landing", "2019-07-01",
  1, "registration", "2019-07-02",
  1, "purchase", "2019-07-07",
  1, "purchase", "2019-07-10",
  2, "landing", "2019-08-01",
  2, "registration", "2019-08-15",
  3, "landing", "2019-05-01",
  3, "registration", "2019-06-01",
  3, "purchase", "2019-06-04",
  4, "landing", "2019-06-13")

activity \%>\%
  funnel_start(moment_type = "landing",
               moment = "event",
               tstamp = "timestamp",
               user = "user_id")  \%>\%
funnel_step(moment_type = "registration",
           type = "first-firstafter")

}
