% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_pred.R
\name{funest_pred}
\alias{funest_pred}
\title{Predicting survival probability with time-varing covariates}
\usage{
funest_pred(
  funest.fit,
  long_test,
  surv_test,
  tv_names,
  fv_names,
  t_star,
  t_pred
)
}
\arguments{
\item{funest.fit}{returned object from funest_fit() function}

\item{long_test}{long form of survival data from the testing set}

\item{surv_test}{short form of survival data from the testing set}

\item{tv_names}{a list of names of time-varying covariates}

\item{fv_names}{a list of names of fixed covariates}

\item{t_star}{time for the last observed biomarker measurement}

\item{t_pred}{time at prediction}
}
\value{
A list of three items. The first is a matrix of individual ID and
their corresponding predicted survival probability. The second is
the estimated Brier score. The third is the estimated area under the ROC curve.
\itemize{
\item pred_pb - predicted survival probability at t_pred for each individual
conditional on being alive at t_star
\item bs - Brier score
\item AUC - area under the receiver operating characteristic (ROC) curve
}
}
\description{
The function funest_pred takes the functional ensemble survival tree object
from funest_fit() to produce predicted survival probability at user specified t_star
 and t_pred along with prediction accuracy measures.
 Must run "predictSurvProb.ranger = predictor_loader()" before calling this function.
}
\examples{
library(funest)
data("long_train")
data("surv_train")
data("long_test")
data("surv_test")
# must run the following line before calling funest_pred()
predictSurvProb.ranger = predictor_loader()
w = funest_fit(long_train, surv_train, tv_names = list("Y1", "Y2", "Y3"),noftree = 10,
 fv_names = list("W"), t_star = 5.5, t_pred = 11)
pred = funest_pred(w, long_test, surv_test, tv_names = list("Y1", "Y2", "Y3"),
 fv_names = list("W"), t_star = 5.5, t_pred = 11)
pred$bs
pred$AUC
}
\references{
\insertRef{auc}{funest}

\insertRef{bs}{funest}
}
