% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_fric.R
\name{fd_fric}
\alias{fd_fric}
\title{Compute Functional Richness (FRic)}
\usage{
fd_fric(traits, sp_com, stand = FALSE)
}
\arguments{
\item{traits}{The matrix dataset for which you want to compute the index}

\item{sp_com}{Site-species matrix with sites as rows and species as columns
if not provided, the function considers all species with equal
abundance in a single site. This can be either a \code{matrix},
a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}} object.
package.}

\item{stand}{a boolean indicating whether to standardize FRic values over
the observed maximum over all species (default: \code{FALSE}).
This scales FRic between 0 and 1.
\strong{NB}: The maximum FRic values only considers species that are
present in \strong{both} site-species and trait matrices.
If you want to consider species that are absent
in the site-species matrix, add corresponding columns of 0s.}
}
\value{
a data.frame with two columns:
\itemize{
\item \code{site} the names of the sites as the row names of the input \code{sp_com},
\item \code{FRic} the values of functional richness at each site.
}
}
\description{
Functional Richness is computed as the volume of the convex hull from all
included traits.
}
\examples{
data(traits_birds)
fd_fric(traits_birds)

}
\references{
Cornwell W. K., Schwilk D. W., Ackerly D. D. (2006), A trait-based test for
habitat filtering; convex hull volume, Ecology 84(6),
\doi{10.1890/0012-9658(2006)87[1465:ATTFHF]2.0.CO;2}
}
