% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMFCC.R
\name{AMFCC_PhaseII}
\alias{AMFCC_PhaseII}
\title{Phase II of the Adaptive Multivariate Functional Control Chart (AMFCC).}
\usage{
AMFCC_PhaseII(data = NULL, mod_Phase_I, ncores = 1)
}
\arguments{
\item{data}{a data frame with the testing data with the following columns:

\if{html}{\out{<div class="sourceCode">}}\preformatted{      var: vector of the variable indexes.

      curve: vector of the curve indexes.

      timeindex: vector of the time indexes corresponding to given elements of \code{grid}.

      x: concatenated vector of the observed curves.
}\if{html}{\out{</div>}}}

\item{mod_Phase_I}{a list with the output of the Phase I.}

\item{ncores}{number of cores to use for parallel computing}
}
\value{
A list containing the following arguments:
\itemize{
\item \code{ARL}: The average run length (ARL) for the monitoring statistics
obtained with the Fisher omnibus and Tippett combining functions.
\item \code{ARL_cont}: The average run length for the contribution to the
monitoring statistics obtained with the Fisher omnibus and Tippett combining
functions.
\item \code{statistics}: A matrix with the values of the Hotelling T^2-type
statistics for each observation and parameter combination.
\item \code{contributions}: A list where each element is a matrix with the
contributions to the Hotelling T^2-type statistics for each observation and
parameter combination.
\item \code{p_values_combined}: A list with two elements containing the monitoring
statistics obtained with the Fisher omnibus and Tippett combining functions.
\item \code{p_values_combined_cont}: A list where each element is a list of two
elements containing the contribution to the monitoring statistics obtained
with the Fisher omnibus and Tippett combining functions.
\item \code{CL}: The control limits for the monitoring statistics obtained with
the Fisher omnibus and Tippett combining functions.
\item \code{CL_cont}: The control limits for the contribution to the monitoring
statistics obtained with the Fisher omnibus and Tippett combining functions.
}
}
\description{
This function implements the monitoring phase (Phase II) of the
Adaptive Multivariate Functional Control Chart.
}
\examples{
library(funcharts)
N <- 10
l_grid <- 10
p <- 2
grid <- seq(0, 1, l = l_grid)


Xall_tra <- funcharts::simulate_mfd(
  nobs = N,
  p = p,
  ngrid = l_grid,
  correlation_type_x = c("Bessel", "Gaussian")
)
X_tra <-
  data.frame(
    x = c(Xall_tra$X_list[[1]], Xall_tra$X_list[[2]]),
    timeindex = rep(rep(1:l_grid, each = (N)), p),
    curve = rep(1:(N), l_grid * p),
    var = rep(1:p, each = l_grid * N)
  )

Xall_II <- funcharts::simulate_mfd(
  nobs = N,
  p = p,
  ngrid = l_grid,
  shift_type_x = list("A", "B"),
  d_x = c(10, 10),
  correlation_type_x = c("Bessel", "Gaussian")
)

X_II <-
  data.frame(
    x = c(Xall_II$X_list[[1]], Xall_II$X_list[[2]]),
    timeindex = rep(rep(1:l_grid, each = (N)), p),
    curve = rep(1:(N), l_grid * p),
    var = rep(1:p, each = l_grid * N)
  )

# AMFCC -------------------------------------------------------------------
print("AMFCC")

mod_phaseI_AMFCC <- AMFCC_PhaseI(
  data_tra = X_tra,
  data_tun =
    NULL,
  grid = grid,
  ncores = 1
)

mod_phaseII_AMFCC <- AMFCC_PhaseII(data = X_II,
mod_Phase_I = mod_phaseI_AMFCC,
ncores = 1)

plot(mod_phaseII_AMFCC)
plot(mod_phaseII_AMFCC,type='cont',ind_obs=1)

}
\references{
Centofanti, F., A. Lepore, and B. Palumbo (2025).
An Adaptive Multivariate Functional Control Chart.
Accepted for publication in \emph{Technometrics}.
}
\author{
F. Centofanti
}
