% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfcc.R
\name{functional_filter}
\alias{functional_filter}
\title{Finds functional componentwise outliers}
\usage{
functional_filter(
  mfdobj,
  method_pca = "ROBPCA",
  alpha = 0.95,
  fev = 0.999,
  delta = 0.1,
  alpha_binom = 0.99,
  bivariate = TRUE,
  max_proportion_componentwise = 0.5
)
}
\arguments{
\item{mfdobj}{A multivariate functional data object of class mfd.}

\item{method_pca}{The method used in \code{rpca_mfd} to perform
robust multivariate functional principal component analysis (RoMFPCA).
See \code{\link{rpca_mfd}}.}

\item{alpha}{Probability value such that only values of functional distances greater than
the \code{alpha}-quantile of the Chi-squared
distribution, with a number of degrees of freedom equal to the number
of principal components selected by \code{fev}, are considered
to determine the proportion of flagged componentwise outliers.
Default value is 0.95, as recommended by Agostinelli et al. (2015).
See Capezza et al. (2022) for more details.}

\item{fev}{Number between 0 and 1 denoting the fraction
of variability that must be explained by the
principal components to be selected to calculate functional distances after
applying RoMFPCA on \code{mfdobj}. Default is 0.999.}

\item{delta}{Number between 0 and 1 denoting the parameter of the
Binomial distribution whose \code{alpha_binom}-quantile
determines the threshold
used in the bivariate filter.
Given the i-th observation and the j-th functional variable,
the number of pairs flagged as functional componentwise outliers in
the i-th observation where the component (i, j) is involved
is compared against this threshold to identify additional functional
componentwise outliers to the ones found by the univariate filter.
Default is 0.1, recommended as conservative choice by Leung et al. (2017).
See Capezza et al. (2022) for more details.}

\item{alpha_binom}{Probability value such that the \code{alpha}-quantile
of the Binomial distribution is considered as threshold
in the bivariate filter. See \code{delta} and Capezza et al. (2022)
for more details. Default value is 0.99.}

\item{bivariate}{If TRUE, both univariate and bivariate filters
are applied. If FALSE, only the univariate filter is used.
Default is TRUE.}

\item{max_proportion_componentwise}{If the functional filter identifies a proportion of functional
componentwise outliers larger than \code{max_proportion_componentwise},
for a given observation, then it is considered as a functional casewise
outlier. Default value is 0.5.}
}
\value{
A list with two elements.
The first element is an \code{mfd} object containing
the original observation in the \code{mfdobj} input, but where
the basis coefficients of the components identified as functional
componentwise outliers are replaced by NA.
The second element of the list is a list of numbers, with length equal
to the number of functional variables in \code{mfdobj}.
Each element of this list contains the observations of the flagged
functional componentwise outliers for the corresponding functional variable.
}
\description{
It finds functional componentwise outliers
as described in Capezza et al. (2022).
}
\examples{
\dontrun{
library(funcharts)
mfdobj <- get_mfd_list(air, grid = 1:24, n_basis = 13, lambda = 1e-2)
plot_mfd(mfdobj)
out <- functional_filter(mfdobj)
}

}
\references{
Agostinelli, C., Leung, A., Yohai, V. J., and Zamar, R. H. (2015).
Robust estimation of
multivariate location and scatter in the presence of cellwise and
casewise contamination.
\emph{Test}, 24(3):441–461.

Capezza, C., Centofanti, F., Lepore, A., Palumbo, B. (2022)
Robust Multivariate Functional Control Charts.
\emph{arXiv:2207.07978v}

Leung, A., Yohai, V., and Zamar, R. (2017).
Multivariate location and scatter matrix
estimation under cellwise and casewise contamination.
\emph{Computational Statistics & Data Analysis}, 111:59–76.
}
