% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_plottingFunctions.R
\name{plotX-generic}
\alias{plotX-generic}
\title{Diagnostic plot for quality-enhanced models}
\arguments{
\item{x.model}{an object containing the model for which the quality plot is to be made.}

\item{...}{additional arguments affecting the plot.}
}
\value{
None.
}
\description{
This method provides plots for assessing the quality of regression models whose structure
  have been somehow optimized for predictability.
}
\examples{
require(funGp) # a package with a plotX method implemented

# generating input and output data
set.seed(100)
n.tr <- 2^5
sIn <- expand.grid(x1 = seq(0,1,length = n.tr^(1/5)), x2 = seq(0,1,length = n.tr^(1/5)),
                   x3 = seq(0,1,length = n.tr^(1/5)), x4 = seq(0,1,length = n.tr^(1/5)),
                   x5 = seq(0,1,length = n.tr^(1/5)))
fIn <- list(f1 = matrix(runif(n.tr*10), ncol = 10), f2 = matrix(runif(n.tr*22), ncol = 22))
sOut <- fgp_BB7(sIn, fIn, n.tr)
\donttest{
# optimizing the model structure with fgpm_factory (~5 seconds)
xm <- fgpm_factory(sIn = sIn, fIn = fIn, sOut = sOut)

# assessing the quality of the model - absolute and w.r.t. the other explored models
plotX(xm)
}

}
\seealso{
\strong{*} \link[funGp]{plotX} for the diagnostic plot of a quality-enhanced funGp model.
}
