% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funDataMethods.R
\name{Math.funData}
\alias{Math.funData}
\alias{Math,funData-method}
\alias{Math,multiFunData-method}
\alias{Math,irregFunData-method}
\title{Mathematical operations for functional data objects}
\usage{
\S4method{Math}{funData}(x)

\S4method{Math}{multiFunData}(x)

\S4method{Math}{irregFunData}(x)
}
\arguments{
\item{x}{An object of class \code{funData}, \code{irregFunData} or
\code{multiFunData}.}
}
\value{
An object of the same functional data class as \code{x}.
}
\description{
These functions allow to apply mathematical operations (such as \eqn{exp(),
log(), sin(), cos()} or \eqn{abs()} to functional data objects based on
\code{\link[methods]{Math}}.  The operations are made pointwise for each
observation.
}
\examples{
oldpar <- par(no.readonly = TRUE)
par(mfrow = c(1,2))

# simulate a funData object on 0..1 with 10 observations
argvals <- seq(0, 1, 0.01)
f <- simFunData(argvals = argvals, N = 10, 
                M = 5, eFunType = "Fourier", eValType = "linear")$simData

### FunData
plot(f, main = "Original data")
plot(abs(f), main = "Absolute values")

### Irregular
# create an irrgFunData object by sparsifying f
i <- as.irregFunData(sparsify(f, minObs = 5, maxObs = 10))

plot(i, main = "Sparse data")
plot(cumsum(i), main = "'cumsum' of sparse data")

### Multivariate
m <- multiFunData(f, -1*f)
plot(m, main = "Multivariate Data")
plot(exp(m), main = "Exponential")

par(oldpar)
}
\seealso{
\code{\linkS4class{funData}}, \code{\linkS4class{irregFunData}},
  \code{\linkS4class{multiFunData}}, \link[methods]{Math}
}
