% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbose.R
\name{verbose}
\alias{verbose}
\alias{make_verbose}
\title{Verbose}
\usage{
verbose(
  ...,
  .fill = getOption("fuj.verbose.fill"),
  .label = getOption("fuj.verbose.label"),
  .verbose = getOption("fuj.verbose", getOption("verbose"))
)

make_verbose(opt)
}
\arguments{
\item{...}{A message to display.  When \code{...} is \code{NULL} (and only \code{NULL}), no
message will display.}

\item{.fill}{When \code{TRUE}, each new line will be prefixed with the verbose
label (controlled through \code{options("fuj.verbose.fill")})}

\item{.label}{A label to prefix the message with (controlled through
\code{options("fuj.verbose.label")})}

\item{.verbose}{When \code{TRUE} (or is a function when returns \code{TRUE}) prints out
the message.}

\item{opt}{An option to use in lieu of \code{fun.verbose}.  Note:
\code{options("fuj.verbose")} is temporarily set to \code{isTRUE(getOption(opt))}
when the function is evaluate, but is reset to its original value on exit.}
}
\value{
None, called for its side-effects.  When conditions are met, will
signal a \code{verboseMessage} condition.
}
\description{
Simple verbose condition handling
}
\details{
\code{\link[=verbose]{verbose()}} can be safely placed in scripts to signal additional
message conditions.  \code{\link[=verbose]{verbose()}} can be controlled with
\code{options("verbose")} (the default) and an override,
\code{options("fuj.verbose")}.  The latter can be set to a function whose result
will be used for conditional evaluation.

\code{\link[=make_verbose]{make_verbose()}} allows for the creation of a custom verbose function.
}
\examples{
op <- options(verbose = FALSE)
verbose("will not show")

options(verbose = TRUE)
verbose("message printed")
verbose("multiple lines ", "will be ", "combined")
options(op)

op <- options(fuj.verbose = function() TRUE)
verbose("function will evaluate")
verbose(NULL) # nothing
verbose(NULL, "something")
verbose(if (FALSE) {
"`if` returns `NULL` when not `TRUE`, which makes for additional control"
})
options(op)

# make your own verbose
verb <- make_verbose("fuj.foo.bar")
verb("will not show")
options(fuj.foo.bar = TRUE)
verb("will show")
}
