% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition.R
\name{new_condition}
\alias{new_condition}
\title{New condition}
\usage{
new_condition(
  msg = "",
  class = NULL,
  call = NULL,
  type = c("error", "warning", NA_character_),
  message = msg,
  pkg = TRUE
)
}
\arguments{
\item{msg, message}{A message to print}

\item{class}{Character string of a single condition class}

\item{call}{A call expression}

\item{type}{The type (additional class) of condition: either \verb{error"},
\code{"warning"} or \code{NA}, which is treated as \code{NULL}}

\item{pkg}{Control or adding package name to condition.  If \code{TRUE} will try
to get the current package name (via \code{.packageName}) from, presumably, the
developmental package.  If \code{FALSE}, no package name is prepended to the
condition class as a new class.  Otherwise, a package can be explicitly set
with a single length character.}
}
\value{
A \code{condition} with the classes specified from \code{class} and \code{type}
}
\description{
Template for a new condition.  See more at \link[base:conditions]{base::conditions}
}
\details{
The use of \code{.packageName} when \code{pkg = TRUE} may not be valid during
active development.  When the attempt to retrieve the \code{.packageName} object
is unsuccessful, the error is quietly ignored.  However, this should be
successful once the package is build and functions can then utilize this
created object.
}
\examples{
# empty condition
x <- new_condition("informative error message", class = "foo")
try(stop(x))

# with pkg
x <- new_condition("msg", class = "foo", pkg = "bar")
# class contains multiple identifiers, including a "bar:fooError"
class(x)
# message contains package information at the end
try(stop(x))
}
