% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seg_stats.R
\name{qc.from.segstats.table}
\alias{qc.from.segstats.table}
\title{Perform data quality check based on a segstats table.}
\usage{
qc.from.segstats.table(
  filepath,
  z_threshold = 2.8,
  verbosity = 1L,
  num_bad_regions_allowed = 1L
)
}
\arguments{
\item{filepath}{path to input file, a tab-separated file generated by running 'aparcstats2table' or 'asegstats2table'. The command line in the system shell would be something like 'aparcstats2table_bin --subjectsfile $subjects_file --meas $measure --hemi $hemi -t $aparc_output_table'.}

\item{z_threshold}{numerical, the cutoff value for considering a subject an outlier (in standard deviations).}

\item{verbosity}{integer, controls the output to stdout. 0=off, 1=normal, 2=verbose.}

\item{num_bad_regions_allowed}{integer, the number of regions in which subjects are allowed to be outliers without being reported as potentially failed segmentation}
}
\value{
vector of character strings, the subject identifiers which potentially failed segmentation
}
\description{
Determine subjects that potentially failed segmentation, based on segstats table data. The input table file must be a segmentation or parcellation table, generated by running the FreeSurfer tools 'aparcstats2table' or 'asegstats2table' for your subjects.
}
\keyword{internal}
