% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hourly_temps.R
\name{hourly_temps}
\alias{hourly_temps}
\title{Estimation of hourly temperatures from daily data}
\usage{
hourly_temps(climdata, latitude)
}
\arguments{
\item{climdata}{a data frame containing the columns Year, Month, Day,
Tmax and Tmin. Data must not contain any gap.}

\item{latitude}{the latitude of the site, in decimal degrees.}
}
\value{
a dataframe containing the columns Date, Year, Month, Day, DOY,
Hour, Sunrise (hour of sunrise), Sunset (hour of sunset), Daylength and
Temp (hourly temperature).
}
\description{
This function generates hourly temperatures from daily maximum and
minimum values, using the method proposed by Linvill (1990), which also
requires sunset and sunrise calculation for each day in the series.
Sunset and sunrise hours for a location are internally estimated using 
the function solar_times from the latitude and the day of the year (DOY)
using the equations by Spencer (1971) and Almorox et al. (2005).
}
\examples{

# Generate hourly temperatures
library(tidyverse)
library(lubridate)
Tudela_HT <- hourly_temps(Tudela_DW,42.13132)

}
\references{
Almorox J, Hontoria C and Benito M, 2005. Statistical validation of
daylength definitions for estimation of global solar radiation in Toledo,
Spain. Energy Conversion and Management 46, 1465-1471.

Linvill DE, 1990. Calculating chilling hours and chill units from daily
maximum and minimum temperature observations. HortScience 25, 14-16.

Spencer JW, 1971. Fourier series representation of the position of the Sun.
Search 2, 172.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
