% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cent_sums}
\alias{cent_sums}
\alias{join_cent_sums}
\alias{unjoin_cent_sums}
\title{Centered sums; join and unjoined.}
\usage{
cent_sums(v, max_order = 5L, na_rm = FALSE)

join_cent_sums(ret1, ret2)

unjoin_cent_sums(ret3, ret2)
}
\arguments{
\item{v}{a vector}

\item{max_order}{the maximum order of the centered moment to be computed.}

\item{na_rm}{whether to remove NA, false by default.}

\item{ret1}{an \eqn{ord+1} vector as output by \code{\link{cent_sums}} consisting of
the count, the mean, then the k through ordth centered sum of some observations.}

\item{ret2}{an \eqn{ord+1} vector as output by \code{\link{cent_sums}} consisting of
the count, the mean, then the k through ordth centered sum of some observations.}

\item{ret3}{an \eqn{ord+1} vector as output by \code{\link{cent_sums}} consisting of
the count, the mean, then the k through ordth centered sum of some observations.}
}
\value{
a vector the same size as the input consisting of the adjusted version of the input.
When there are not sufficient (non-nan) elements for the computation, \code{NaN} are returned.
}
\description{
Compute, join, or unjoin centered sums.
}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{

 set.seed(1234)
 x1 <- rnorm(1e3,mean=1)
 x2 <- rnorm(1e3,mean=1)
 max_ord <- 6L
 rs1 <- cent_sums(x1,max_ord)
 rs2 <- cent_sums(x2,max_ord)
 rs3 <- cent_sums(c(x1,x2),max_ord)
 rs3alt <- join_cent_sums(rs1,rs2)
 stopifnot(max(abs(rs3 - rs3alt)) < 1e-7)
 rs1alt <- unjoin_cent_sums(rs3,rs2)
 rs2alt <- unjoin_cent_sums(rs3,rs1)
 stopifnot(max(abs(rs1 - rs1alt)) < 1e-7)
 stopifnot(max(abs(rs2 - rs2alt)) < 1e-7)

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Terriberry, T. "Computing Higher-Order Moments Online."
\url{http://people.xiph.org/~tterribe/notes/homs.html}

J. Bennett, et. al., "Numerically Stable, Single-Pass, 
Parallel Statistics Algorithms," Proceedings of IEEE
International Conference on Cluster Computing, 2009.
\url{https://www.semanticscholar.org/paper/Numerically-stable-single-pass-parallel-statistics-Bennett-Grout/a83ed72a5ba86622d5eb6395299b46d51c901265}

Cook, J. D. "Accurately computing running variance."
\url{http://www.johndcook.com/standard_deviation.html}

Cook, J. D. "Comparing three methods of computing 
standard deviation."
\url{http://www.johndcook.com/blog/2008/09/26/comparing-three-methods-of-computing-standard-deviation}
}

