% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_variables.R
\name{write_variables}
\alias{write_variables}
\title{Write Variables YAML for Quarto Projects}
\usage{
write_variables(path = here::here())
}
\arguments{
\item{path}{Character. Path to the project directory. Default is current project
root via \code{\link[here]{here}}.}
}
\value{
Invisibly returns the path to the created file.
}
\description{
This function creates a \code{_variables.yml} file in a Quarto project
and opens it for editing.
}
\details{
The function will attempt to use the current froggeR settings from the global
config path. If no global configurations exist, a template \code{_variables.yml}
will be created. This file stores reusable metadata (author name, email, ORCID, etc.)
that can be referenced throughout Quarto documents.
}
\examples{
# Write the _variables.yml file
if (interactive()) {
  temp_dir <- tempdir()
  # In an interactive session, this would also open the file for editing.
  write_variables(temp_dir)
  # Verify the file was created
  file.exists(file.path(temp_dir, "_variables.yml"))
}

}
\seealso{
\code{\link{settings}}, \code{\link{save_variables}},
  \code{\link{brand_settings}}, \code{\link{quarto_project}}
}
