% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_readme.R
\name{write_readme}
\alias{write_readme}
\title{Create a project README file}
\usage{
write_readme(path = here::here(), .initialize_proj = FALSE)
}
\arguments{
\item{path}{Character string. Path to the project directory.}

\item{.initialize_proj}{Logical. TRUE only if starting a 
\code{froggeR::quarto_project()}.}
}
\value{
Creates a comprehensive README template for project documentation.
}
\description{
This function streamlines project documentation by a README.md file.
}
\details{
The README.md template includes structured sections for:
\itemize{
  \item Project description (study name, principal investigator, author)
  \item Project setup steps for reproducibility
  \item File and directory descriptions
  \item Miscellaneous project notes
}
}
\examples{
# Create a temporary directory for testing
tmp_dir <- tempdir()

# Write the README file
write_readme(path = tmp_dir)

# Confirm the file was created (optional, for user confirmation)
file.exists(file.path(tmp_dir, "README.md"))

# Clean up: Remove the created file
unlink(file.path(tmp_dir, "README.md"))

}
