% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_body.R
\name{plot_body}
\alias{plot_body}
\title{Plots the body of a non-primitive function}
\usage{
plot_body(.f, nudge_y = 0, font_size = 0.8, line_width = 110)
}
\arguments{
\item{.f}{A function}

\item{nudge_y}{Moves the function body up or down, number}

\item{font_size}{Specifies text size, positive number}

\item{line_width}{Specifies how wide a line can be, positive number}
}
\value{
text in plot window, also returns function
}
\description{
Plots the body of a function so that you can easily see it while using other functions
in this package. It can be piped into and will return the function that you put into it.
}
\section{Warning}{

Functions with large bodies will be difficult to plot correctly
}

\examples{

plot_body(lapply)
plot_body(strwrap, line_width = 90, font_size = .75, nudge_y = .12)

}
\seealso{
\code{\link{list_body}}
}
