% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillovers.R
\name{spilloverRollingBK09}
\alias{spilloverRollingBK09}
\title{Computing rolling frequency spillover from a fevd as defined by Barunik, Krehlik (2015)}
\usage{
spilloverRollingBK09(data, p, type, window, n.ahead, partition, table = F,
  no.corr, absolute, cluster = NULL)
}
\arguments{
\item{data}{variable containing the dataset}

\item{p}{lags in the VAR estimate.}

\item{type}{which type of VAR to use, see help for VAR from vars package}

\item{window}{length of the window to be rolled}

\item{n.ahead}{how many periods ahead should the FEVD be computed, generally this number
should be high enough so that it won't change with additional period}

\item{partition}{defines the frequency partitions to which the spillover should be decomposed}

\item{table}{boolean whether the full spillover table should be returned}

\item{no.corr}{boolean parameter whether the off-diagonal in the covariance matrix should be
set to zero}

\item{absolute}{boolean defining whether to compute the within or absolute spillover}

\item{cluster}{either NULL for no parallel processing or the variable containing the cluster.}
}
\value{
A corresponding spillover value on a given freqeuncy band, ordering of bands corresponds to the ordering of original bounds.
}
\description{
This function computes the rolling spillover using the standard VAR estimate.
We implement the parallel version for faster processing. The window is of fixed window
and is rolled over the data. Interpretation of the other parameters is the same as in the
standard computation of spillover.
}
\author{
Tomas Krehlik <tomas.krehlik@gmail.com>
}
