% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_table.R
\name{read_fs_table}
\alias{read_fs_table}
\title{Read Freesurfer Table Output}
\usage{
read_fs_table(file, sep = NULL, stringsAsFactors = FALSE, header = TRUE, ...)
}
\arguments{
\item{file}{(character path) filename of text file}

\item{sep}{separator to override attribute of file, to 
pass to \code{\link{read.table}}.}

\item{stringsAsFactors}{(logical) passed to \code{\link{read.table}}}

\item{header}{Is there a header in the data}

\item{...}{additional arguments to \code{\link{read.table}}}
}
\value{
\code{data.frame} from the file
}
\description{
This function reads output from a Freesurfer table command,
e.g. \code{aparcstats2table}, \code{asegstats2table}
}
\examples{
if (have_fs()) {
   outfile = aparcstats2table(subjects = "bert",
                    hemi = "lh",
                    meas = "thickness")
   df = read_fs_table(outfile)
   seg_outfile = asegstats2table(subjects = "bert", meas = "mean")
   df_seg = read_fs_table(seg_outfile)
}
\dontrun{
### using the pipe
df_seg = asegstats2table(subjects = "bert", meas = "mean") \%>\% 
            read_fs_table
}
}
