% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aparcs_to_bg.R
\name{aparcs_to_bg}
\alias{aparcs_to_bg}
\title{Convert Freesurfer aparcs Table to brainGraph}
\usage{
aparcs_to_bg(subjects, measure, ...)
}
\arguments{
\item{subjects}{subjects to analyze, 
passed to \code{\link{aparcstats2table}}}

\item{measure}{measure to be analyzed, 
passed to \code{\link{aparcstats2table}}}

\item{...}{additional arguments passed to \code{\link{aparcstats2table}}}
}
\value{
Long \code{data.frame}
}
\description{
Converts Freesurfer aparcs table to brainGraph naming
convention, relying on \code{\link{aparcstats2table}}
}
\examples{
if (have_fs()) {
   fs_subj_dir() 
   df = aparcs_to_bg(subjects = "bert", measure = "thickness")
   print(head(df))
}
}

