% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomPersonEP.R
\name{randomPersonEP}
\alias{randomPersonEP}
\title{Random person exclusion power}
\usage{
randomPersonEP(x, id, markers = NULL, disableMutations = NA, verbose = TRUE)
}
\arguments{
\item{x}{A \code{ped} object with attached markers.}

\item{id}{The ID label of a single pedigree member.}

\item{markers}{A vector indicating the names or indices of markers attached
to the source pedigree. If NULL (default), then all markers attached to the
source pedigree are used. If \code{alleles} or \code{afreq} is non-NULL, then this
parameter is ignored.}

\item{disableMutations}{This parameter determines how mutation models are
treated. Possible values are as follows:
\itemize{
\item \code{NA} (the default): Mutations are disabled only for those markers whose
known genotypes are consistent with the pedigree. This is determined by
temporarily removing all mutation models and checking which markers have
nonzero likelihood.
\item \code{TRUE}: Mutations are disabled for all markers. This will result in an
error if any markers are inconsistent.
\item \code{FALSE}: No action is done to disable mutations.
\item A vector containing the names or indices of those markers for which
mutations should be disabled.
}}

\item{verbose}{A logical.}
}
\value{
The \code{EPresult} object returned by \code{\link[=exclusionPower]{exclusionPower()}}.
}
\description{
This is a special case of \code{\link[=exclusionPower]{exclusionPower()}}, computing the power to exclude
a random person as a given pedigree member. More specifically, the function
computes the probability of observing, in an individual unrelated to the
family individual, a genotype incompatible with the typed family members.
}
\examples{

# Four siblings:
x = nuclearPed(4)

# First 3 sibs typed with 4 triallelic markers
x = markerSim(x, N = 4, ids = 3:5, alleles = 1:3, seed = 577, verbose = FALSE)

# Probability that a random man is excluded as the fourth sibling
randomPersonEP(x, id = 6)

}
