% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/parts.R, R/parts.lhs.get.R, R/parts.lhs.set.R, R/parts.op.get.R, R/parts.op.set.R, R/parts.rhs.get.R, R/parts.rhs.set.R
\docType{methods}
\name{formula.parts}
\alias{.lhs.singular}
\alias{.replace.lhs.plural}
\alias{.replace.lhs.singular}
\alias{.replace.op.plural}
\alias{.replace.rhs.plural}
\alias{.replace.rhs.singular}
\alias{.replace.ths.plural}
\alias{.rhs.singular}
\alias{formula.parts}
\alias{lhs}
\alias{lhs,<--method}
\alias{lhs,call-method}
\alias{lhs,expression-method}
\alias{lhs,formula-method}
\alias{lhs,list-method}
\alias{lhs<-}
\alias{lhs<-,call-method}
\alias{lhs<-,expression-method}
\alias{lhs<-,formula-method}
\alias{lhs<-,list-method}
\alias{op}
\alias{op,<--method}
\alias{op,call-method}
\alias{op,expression-method}
\alias{op,formula-method}
\alias{op,list-method}
\alias{op,name-method}
\alias{op<-}
\alias{op<-,call-method}
\alias{op<-,expression-method}
\alias{op<-,formula-method}
\alias{op<-,list-method}
\alias{rhs}
\alias{rhs,<--method}
\alias{rhs,call-method}
\alias{rhs,expression-method}
\alias{rhs,formula-method}
\alias{rhs,list-method}
\alias{rhs<-}
\alias{rhs<-,call-method}
\alias{rhs<-,expression-method}
\alias{rhs<-,formula-method}
\alias{rhs<-,list-method}
\title{Manipulate the component parts of formulas, expressions, calls, name/symbols
and list and vectors of such objects.}
\usage{
.lhs.singular(x)

lhs(x, ...)

\S4method{lhs}{call}(x)

\S4method{lhs}{formula}(x)

\S4method{lhs}{`<-`}(x)

\S4method{lhs}{expression}(x, ...)

\S4method{lhs}{list}(x, ...)

lhs(x) <- value

.replace.lhs.singular(x, value)

\S4method{lhs}{call}(x) <- value

\S4method{lhs}{formula}(x) <- value

.replace.lhs.plural(x, value)

\S4method{lhs}{expression}(x) <- value

\S4method{lhs}{list}(x) <- value

op(x)

\S4method{op}{formula}(x)

\S4method{op}{call}(x)

\S4method{op}{name}(x)

\S4method{op}{expression}(x)

\S4method{op}{list}(x)

\S4method{op}{`<-`}(x)

op(x) <- value

\S4method{op}{call}(x) <- value

\S4method{op}{formula}(x) <- value

.replace.op.plural(x, value)

\S4method{op}{expression}(x) <- value

\S4method{op}{list}(x) <- value

rhs(x, ...)

.rhs.singular(x)

\S4method{rhs}{call}(x)

\S4method{rhs}{formula}(x)

\S4method{rhs}{`<-`}(x)

\S4method{rhs}{expression}(x, ...)

\S4method{rhs}{list}(x, ...)

rhs(x) <- value

.replace.rhs.singular(x, value)

\S4method{rhs}{call}(x) <- value

\S4method{rhs}{formula}(x) <- value

.replace.rhs.plural(x, value)

\S4method{rhs}{expression}(x) <- value

\S4method{rhs}{list}(x) <- value
}
\arguments{
\item{x}{object from where to get/set the lhs/rhs}

\item{...}{arguments passed to additional methods

\code{lhs} retrieves the left-hand side
\code{rhs} retrieves the right-hand side
\code{op}  retrieves the operation
\code{op.type} returns the type operator

There are also functions \code{lhs.vars} and \code{rhs.vars}.  Like
\code{ \link{all.vars} }, these functions interpret the variables on the
left-hand and right-hand sides respectively.

These are simple functions for extracting the left-hand side, right-hand
side, operator and operator type from formulas, expressions, calls,
names/symbols and list containing these objects.  lhs, rhs are only defined
for formulas and calls ( and list and expressions ) that are defined with
either one of the relational or tilde ('~') operators. If the object does
not contain one of these operators, it will fail with a warning.

The defined operator types are defined by the operator.tools package: See
\code{\link[operator.tools]{operators}} and
\code{\link[operator.tools]{setOperator}}

The \code{lhs.vars} and \code{rhs.vars} methods, return the variables used on
the lhs and rhs, respectively.  If special formula variables are used, such
as '.', a data.frame or environment must also be provided such that the
variable list may be properly infered.}

\item{value}{the value to set for the lhs/rhs}
}
\value{
Value depends on the argument.
}
\description{
\code{lhs, rhs, op, and op.type } retrieve the various parts of R formulas,
calls, expressions, names/symbols.  These functions were designed to
greatly facilitate symbolic manupulation using native R objects.  Also
provided are methods to handle list of these objects.
}
\examples{
# FORMULA
  f <- A + B ~ C + D
  lhs(f)
  lhs(f) <- quote( E / F )

  rhs(f)
  rhs(f) <- quote( G + H )
  op(f)
  op(rhs(f))
  op( quote(A) )  # NULL:
  op.type(f)

  # ONE-SIDED FORMULA
  f <- ~ A   #
  lhs(f)     # NULL
  rhs(f)     # A


  # EXPRESSION
  e <- expression( A + B == C + D )
  lhs(e)
  rhs(e)
  op(e)
  op.type(e)


  # CALL
  c <- quote( A + B > C + D )
  lhs(c)
  lhs(c) <- quote(E)
  rhs(c)

  op(c)
  op.type(c)

  # ASSIGNMENT
  a  <- quote( A <- B )
  lhs(a)
  rhs(a)
  op(a)
  op.type(a)
}
\author{
Christopher Brown
}
\seealso{
terms, all.vars, all.names, \code{\link[operator.tools]{operators}}
}

