% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{FM_le}
\alias{FM_le}
\title{Appends entry to log file}
\usage{
FM_le(state, entry, escape_braces = TRUE, entry_type = "alert")
}
\arguments{
\item{state}{Module state after yaml read}

\item{entry}{Text to add}

\item{escape_braces}{Set to \code{TRUE} (default) to escape curly braces in the entry, set to \code{FALSE} to have the values interpreted.}

\item{entry_type}{Set to either "alert"(default), "danger", "info", "success", or "warning"}
}
\value{
Boolean value indicating success (\code{TRUE}) or failure (\code{FALSE}).
}
\description{
Add the supplied txt and the module type to the log file
}
\examples{
# We need a module state to use this function:
id="UD"
sess_res = UD_test_mksession(session=list(), id=id)
state   = sess_res$state
FM_le(state, "This is a normal  message")
FM_le(state, "This is a danger  message", entry_type="danger")
FM_le(state, "This is a info    message", entry_type="info")
FM_le(state, "This is a success message", entry_type="success")
FM_le(state, "This is a warning message", entry_type="warning")
}
