% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_transects_from_pcl.R
\name{split_transects_from_pcl}
\alias{split_transects_from_pcl}
\title{Split transects from PCL}
\usage{
split_transects_from_pcl(
  pcl_data,
  transect.length,
  marker.spacing,
  DEBUG = FALSE,
  data_dir,
  output_file_name
)
}
\arguments{
\item{pcl_data}{data frame of unprocessed PCL data.}

\item{transect.length}{total transect length. Default value is 40 meters.}

\item{marker.spacing}{distance between markers in meters within the PCL data. Default value is 10 m.}

\item{DEBUG}{check to see order of final output. Default is FALSE.}

\item{data_dir}{directory where PCL data .csv are stored if value is used.}

\item{output_file_name}{old code relic that doesn't do much.}
}
\description{
\code{split_transects_from_pcl} places data values into x-bins (x-coordinates
and) and z-bins (z-coordinates)
}
\details{
Function to add two additional columns
to the pcl dataset, one for the segment
 (which should only be from 1-4) and is
designated by a -99999999 value in the
return_distance column
The only required parameters are the data
frame of pcl data, with the length of transect and the marker
spacing.
}
\examples{
# Function that has the algorithm that splits the raw data into defined, equidistant x-bins.
 pcl_split <- split_transects_from_pcl(pcl_adjusted,
 transect.length = 40, marker.spacing = 10)

}
