% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{get_wh}
\alias{get_wh}
\title{Get widths and height the forestplot}
\usage{
get_wh(plot, unit = c("in", "cm", "mm"))
}
\arguments{
\item{plot}{A forest plot object.}

\item{unit}{Unit of the plot size in \code{units} ("in", "cm", or "mm")to be saved.}
}
\value{
A named vector of width and height
}
\description{
\code{get_wh} can be used to find the correct width and height of the forestplot
for saving, as the width and height is difficult to fit for saving.
}
\examples{
\dontrun{
 dt <- read.csv(system.file("extdata", "example_data.csv", package = "forestploter"))
 dt <- dt[1:6,1:6]

 dt$` ` <- paste(rep(" ", 20), collapse = " ")

 p <- forest(dt[,c(1:3, 7)],
             est = dt$est,
             lower = dt$low,
             upper = dt$hi,
             ci_column = 4)

# get_wh example
p_wh <- get_wh(p)
pdf('test.pdf',width = p_wh[1], height = p_wh[2])
plot(p)
dev.off()
}
}
