% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa.R
\name{fa}
\alias{fa}
\title{Generate a Font Awesome icon as an SVG}
\usage{
fa(
  name,
  fill = NULL,
  fill_opacity = NULL,
  stroke = NULL,
  stroke_width = NULL,
  stroke_opacity = NULL,
  height = NULL,
  position = NULL
)
}
\arguments{
\item{name}{The name of the Font Awesome icon.}

\item{fill, fill_opacity}{The fill color of the icon can be set with \code{fill}.
If not provided then the default value of \code{"currentColor"} is applied so
that the SVG fill matches the color of the parent HTML element's \code{color}
attribute. The opacity level of the SVG fill can be controlled with a
decimal value between \code{0} and \code{1}.}

\item{stroke, stroke_width, stroke_opacity}{The stroke options allow for
setting the color, width, and opacity of the SVG outline stroke. By
default, the stroke width is very small at \code{"1px"} so a size adjustment
with \code{"stroke_width"} can be useful. The \code{"stroke_opacity"} value can be
any decimal values between \code{0} and \code{1} (bounds included).}

\item{height}{The absolute height of the rendered SVG. If nothing is provided
then a default value of \code{"0.75em"} will be applied.}

\item{position}{The value for the \code{position} style attribute. By default,
\code{"relative"} is used here.}
}
\value{
A \code{fontawesome} object that is the styled Font Awesome icon.
}
\description{
Add a Font Awesome icon as SVG contained within \verb{<svg>...</svg>}. We can
optionally set certain style attributes. The \code{fa()} function can be used
directly within inline evaluations of R code in R Markdown documents.
}
\examples{
if (interactive()) {

# Create a Font Awesome SVG icon
fa(name = "r-project")

}

}
