\name{NagelkerkeR2}
\alias{NagelkerkeR2}
\title{Calculate Nagelkerke's R squared.}
\description{To evaluate the goodness of fit of the logistic regression model, calculating Nagelkerke's R squared from the result of glm().  The Nagelkerke's R squared means the power of explanation of the model.}
\usage{NagelkerkeR2(rr)}
\arguments{
 \item{rr}{The object with class "glm" and "lm", which would be generated by glm().}
}
\value{
 \item{N}{The number of observations in which the model were fitted.}
 \item{R2}{Nagelkerke's R squared.}
}
\author{Minato Nakazawa \email{minato-nakazawa@umin.net} \url{http://minato.sip21c.org/}}
\examples{
 res <- glm(cbind(ncases,ncontrols) ~ agegp+alcgp+tobgp, data=esoph, family=binomial())
 summary(res)
 NagelkerkeR2(res)
}
