% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secDetails.R
\name{fmpc_analyst_outlook}
\alias{fmpc_analyst_outlook}
\title{Pull analyst outlook for one or more securities}
\usage{
fmpc_analyst_outlook(
  symbols = c("AAPL"),
  outlook = c("surprise", "grade", "estimate", "recommend", "press"),
  limit = 100
)
}
\arguments{
\item{symbols}{one or more symbols from the FMP available list that can be
found using \code{\link{fmpc_symbols_available}}. A valid API token must be
set in order to enable functionality. See documentation for setting a token
under \code{\link{fmpc_set_token}}.}

\item{outlook}{can be one of: 'surprise' for earnings surprise, 'grade' for
stock grade', 'estimateAnnl' for analysts annual estimates, 'estimateQtr'
for analysts quarterly estimate, 'recommend' for analyst recommendations,
and 'press' for company press releases}

\item{limit}{limit results for each ticker}
}
\value{
data frame of ratings data
}
\description{
Analyst details for one or more securities includes earnings estimates,
earnings surprises, stock grade, analyst recommendations, and company press
releases
}
\examples{

\dontrun{

# Demo can pull AAPL
fmpc_set_token()
fmpc_analyst_outlook('AAPL')

# For multiple symbols, set a valid API Token
fmpc_set_token('FMPAPIKEY')
fmpc_analyst_outlook(c('AAPL','MSFT','SPY'))

}

}
