% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitioning.R
\name{Partitioning}
\alias{Partitioning}
\title{R6 Class representing a partitioning}
\description{
This is the abstract superclass for partitioning objects like \link{PartitioningCtree} and \link{PartitioningRpart}.
A Partitioning contains information about feature subspaces with conditional average marginal effects (cAME) computed for \code{ForwardMarginalEffect} objects.
}
\examples{

## ------------------------------------------------
## Method `Partitioning$compute`
## ------------------------------------------------

# Compute results for an arbitrary partitioning:
# subspaces$compute()

## ------------------------------------------------
## Method `Partitioning$plot`
## ------------------------------------------------

# Plot an arbitrary partitioning:
# subspaces$plot()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{object}}{a \code{ForwardMarginalEffect} object with results computed}

\item{\code{method}}{the method for finding feature subspaces}

\item{\code{value}}{the value of \code{method}}

\item{\code{results}}{descriptive statistics of the resulting feature subspaces}

\item{\code{tree}}{the tree representing the partitioning, a \code{party} object}

\item{\code{tree.control}}{control parameters for the RP algorithm}

\item{\code{computed}}{logical specifying if compute() has been run}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Partitioning-new}{\code{Partitioning$new()}}
\item \href{#method-Partitioning-compute}{\code{Partitioning$compute()}}
\item \href{#method-Partitioning-plot}{\code{Partitioning$plot()}}
\item \href{#method-Partitioning-clone}{\code{Partitioning$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Partitioning-new"></a>}}
\if{latex}{\out{\hypertarget{method-Partitioning-new}{}}}
\subsection{Method \code{new()}}{
Create a Partitioning object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Partitioning$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Partitioning cannot be initialized, only its subclasses}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Partitioning-compute"></a>}}
\if{latex}{\out{\hypertarget{method-Partitioning-compute}{}}}
\subsection{Method \code{compute()}}{
Computes the partitioning, i.e., feature subspaces with more homogeneous FMEs, for a \code{ForwardMarginalEffect} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Partitioning$compute()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{Partitioning} object with results.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Compute results for an arbitrary partitioning:
# subspaces$compute()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Partitioning-plot"></a>}}
\if{latex}{\out{\hypertarget{method-Partitioning-plot}{}}}
\subsection{Method \code{plot()}}{
Plots results, i.e., a decision tree and summary statistics of the feature subspaces, for an \code{Partitioning} object after \verb{$compute()} has been run.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Partitioning$plot()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Plot an arbitrary partitioning:
# subspaces$plot()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Partitioning-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Partitioning-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Partitioning$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
