% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-methods.R
\name{is_valid_bdc}
\alias{is_valid_bdc}
\alias{businessdayconventions}
\title{Business day conventions}
\usage{
is_valid_bdc(bdc)
}
\arguments{
\item{bdc}{a character vector}
}
\value{
a flag (\code{TRUE} or \code{FALSE}) if all the supplied business
day conventions are supported.
}
\description{
Checks whether business day conventions are valid.
}
\details{
The supported day conventions are:
\itemize{
\item u - unadjusted. No adjustments made to a date.
\item f - following. The date is adjusted to the following business day.
\item mf - modified following. As per following convention. However,
if the following business day is in the month following the date, then the
date is adjusted to the preceding business day.
\item p - preceding. The date is adjusted to the preceding business day.
\item mp - modified preceding. As per preceding convention. However, if
the preceding business day is in the month prior to the date, then the
date is adjusted to the following business day.
\item ms - modified succeeding. This convention applies to Australian
bank bills. Australian bank bills' maturities defined as either early
(prior to the 15th) or late month (after the 15th). If the maturity date
calculated straight from a bill's term crosses either the end of the month
or the 15th of the month, the bill's maturity is adjusted to the preceding
business day.
}
}
\seealso{
Other calendar methods: \code{\link{adjust}},
  \code{\link{generate_schedule}}, \code{\link{is_good}},
  \code{\link{is}}, \code{\link{locale}},
  \code{\link{shift}}, \code{\link{tz}}
}
