% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/last.R
\docType{data}
\name{last-mcmc}
\alias{last-mcmc}
\alias{LAST_MCMC}
\alias{last_elapsed}
\alias{last_nsteps}
\alias{last_nchains}
\alias{last_kernel}
\alias{last_conv_checker}
\alias{last_}
\title{Information about the last \code{MCMC} call}
\format{
An object of class \code{fmcmc_last} (inherits from \code{environment}) of length 0.
}
\usage{
LAST_MCMC

last_elapsed()

last_nsteps()

last_nchains()

last_kernel()

last_conv_checker()

last_(x)
}
\arguments{
\item{x}{Character scalar. Name of an argument to retrieve. If \code{x} was not
passed to the last call, the function returns with an error.}
}
\value{
\verb{last_*} returns the corresponding variable.

The function \code{last_elapsed} returns the elapsed time of the last call
to \link{MCMC}. In particular, the \code{MCMC} function records the running time of R
at the beginning and end of the function using \code{\link[=proc.time]{proc.time()}}. So this function
returns the difference between the two (\code{time_end - time_start}).
}
\description{
This environment holds a copy of the last call to \link{MCMC}, including the start
and end time (to compute total elapsed time) of the call. Since the resulting
object of \code{MCMC} is an object of class \link[coda:mcmc]{coda::mcmc}, this is a way to capture
more information in case the user needs it.
}
\keyword{datasets}
