% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fm_index_save}
\alias{fm_index_save}
\alias{fm_index_load}
\title{Save / load FM indices}
\usage{
fm_index_save(index, path)

fm_index_load(path)
}
\arguments{
\item{index}{FM Index to be saved to disk}

\item{path}{Path where to save index to or load index from}
}
\value{
For \code{fm_index_load}, a FM Index object that can be passed to \code{\link[=fm_index_locate]{fm_index_locate()}} for
finding matches in the corpus.

For \code{fm_index_save}, no return value. Called for side-effects.
}
\description{
FM indices can be stored on disk and loaded into memory again in order
to avoid re-computing the index every time a new R session is opened.
}
\section{Functions}{
\itemize{
\item \code{fm_index_save}: Save FM Index to disk

\item \code{fm_index_load}: Load FM Index from disk
}}

\examples{
data("state")
index_1 <- fm_index_create(state.name, case_sensitive = FALSE)

tmp_path <- tempfile()
fm_index_save(index_1, tmp_path)
index_2 <- fm_index_load(tmp_path)

identical(
  fm_index_locate("new", index_1),
  fm_index_locate("new", index_2)
)

}
\seealso{
Other FM Index functions: 
\code{\link{fm_index_create}()},
\code{\link{fm_index_locate}()}
}
\concept{FM Index functions}
