% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_file.R
\name{export_file}
\alias{export_file}
\title{Upload a file from the local system to cloud}
\usage{
export_file(localfile, bucketpath, data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), show_progress = FALSE, ...)
}
\arguments{
\item{localfile}{path of the file to be uploaded}

\item{bucketpath}{path where the file needs to be uploaded, the file name can or cannot be present}

\item{data_source}{the name of the data source, if not set globally. gcs or s3}

\item{bucket}{the name of the bucket, if not set globally}

\item{show_progress}{logical. Shows progress of the upload operation.}

\item{...}{other parameters for gcs_upload or aws.s3::put_object}
}
\value{
the filename and path of the file in the bucket
}
\description{
Write a local file to the cloud, S3 or GCS
}
\examples{
\dontrun{
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
export_file("file-local.csv", "file-on-cloud.csv")
}
}
