% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{getBinVStat}
\alias{getBinVStat}
\title{V Statistic for Binary Matrices}
\usage{
getBinVStat(X)
}
\arguments{
\item{X}{The \eqn{N \times P} binary matrix}
}
\value{
\eqn{V(\mathbf{X})}, the variance of the pairwise Hamming distance between samples
}
\description{
Computes \eqn{V} statistic for a binary matrix \eqn{\mathbf{X}}, as defined in
Aw, Spence and Song (2021+).
}
\details{
Dependencies: getHammingDistance
}
\examples{
X <- matrix(nrow = 5, ncol = 10, rbinom(50, 1, 0.5))
getBinVStat(X)

}
