% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{cachePermute}
\alias{cachePermute}
\title{Permutation by Caching Distances}
\usage{
cachePermute(dists, forward, reverse)
}
\arguments{
\item{dists}{\eqn{{N \choose 2}} by \eqn{B} matrix, with each column
containing the distances (ex: Hamming, \eqn{l_p^p}) for the block}

\item{forward}{\eqn{N \times N} matrix mapping the pairs of sample labels
to index of the \eqn{{N \choose 2}}-length vector}

\item{reverse}{\eqn{{N \choose 2}\times 2} matrix mapping the index to
pairs of sample labels}
}
\value{
A matrix with same dimensions as dists containing
the block-permuted pairwise distances
}
\description{
What do you do when you have to compute pairwise distances many times, and those
damn distances take a long time to compute? Answer: You cache the distances and
permute the underlying sample labels!
}
\details{
This function permutes the distances (Hamming, \eqn{l_p^p}, etc.) within blocks.
Permutations respect the fact that we are actually permuting the
underlying labels. Arguments forward and reverse should be
precomputed using buildForward and buildReverse.

Dependencies: buildForward, buildReverse
}
