% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{compose}
\alias{compose}
\title{Define flextable displayed values}
\usage{
compose(x, i = NULL, j = NULL, value, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{column selection}

\item{value}{a call to function \code{\link{as_paragraph}}.}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
Modify flextable displayed values. Function is
handling complex formatting as well as image insertion.
}
\examples{
library(officer)
ft <- flextable(head( mtcars, n = 10))
ft <- compose(ft, j = "carb", i = ~ drat > 3.5,
  value = as_paragraph("carb is ", as_chunk( sprintf("\%.1f", carb)) )
  )
\donttest{ft <- autofit(ft)}
}
