% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexsurv-package.R
\docType{package}
\name{flexsurv-package}
\alias{_PACKAGE}
\alias{flexsurv}
\alias{flexsurv-package}
\title{flexsurv: Flexible parametric survival and multi-state models}
\description{
flexsurv: Flexible parametric models for time-to-event data, including the
generalized gamma, the generalized F and the Royston-Parmar spline model,
and extensible to user-defined distributions.
}
\details{
\code{\link{flexsurvreg}} fits parametric models for time-to-event
(survival) data.  Data may be right-censored, and/or left-censored, and/or
left-truncated.  Several built-in parametric distributions are available.
Any user-defined parametric model can also be employed by supplying a list
with basic information about the distribution, including the density or
hazard and ideally also the cumulative distribution or hazard.

Covariates can be included using a linear model on any parameter of the
distribution, log-transformed to the real line if necessary.  This
typically defines an accelerated failure time or proportional hazards
model, depending on the distribution and parameter.

\code{\link{flexsurvspline}} fits the flexible survival model of Royston
and Parmar (2002) in which the log cumulative hazard is modelled as a
natural cubic spline function of log time.  Covariates can be included on
any of the spline parameters, giving either a proportional hazards model or
an arbitrarily-flexible time-dependent effect.  Alternative proportional
odds or probit parameterisations are available.

Output from the models can be presented as survivor, cumulative hazard and
hazard functions (\code{\link{summary.flexsurvreg}}).  These can be plotted
against nonparametric estimates (\code{\link{plot.flexsurvreg}}) to assess
goodness-of-fit.  Any other user-defined function of the parameters may be
summarised in the same way.

Multi-state models for time-to-event data can also be fitted with the same
functions.  Predictions from those models can then be made using the
functions \code{\link{pmatrix.fs}}, \code{\link{pmatrix.simfs}},
\code{\link{totlos.fs}}, \code{\link{totlos.simfs}}, or
\code{\link{sim.fmsm}}, or alternatively by \code{\link{msfit.flexsurvreg}}
followed by \code{mssample} or \code{probtrans} from the package
\pkg{mstate}.

Distribution (``dpqr'') functions for the generalized gamma and F
distributions are given in \code{\link{GenGamma}}, \code{\link{GenF}}
(preferred parameterisations) and \code{\link{GenGamma.orig}},
\code{\link{GenF.orig}} (original parameterisations).
\code{\link{flexsurv}} also includes the standard Gompertz distribution
with unrestricted shape parameter, see \code{\link{Gompertz}}.
}
\section{User guide}{
 The \bold{flexsurv user guide} vignette explains the
methods in detail, and gives several worked examples.  A further vignette
\bold{flexsurv-examples} gives a few more complicated examples, and users
are encouraged to submit their own.
}
\author{
Christopher Jackson \email{chris.jackson@mrc-bsu.cam.ac.uk}
}
\references{
Jackson, C. (2016). flexsurv: A Platform for Parametric
Survival Modeling in R. Journal of Statistical Software, 70(8), 1-33.
doi:10.18637/jss.v070.i08

Royston, P. and Parmar, M. (2002).  Flexible parametric
proportional-hazards and proportional-odds models for censored survival
data, with application to prognostic modelling and estimation of treatment
effects. Statistics in Medicine 21(1):2175-2197.

Cox, C. (2008). The generalized \eqn{F} distribution: An umbrella for
parametric survival analysis.  Statistics in Medicine 27:4301-4312.

Cox, C., Chu, H., Schneider, M. F. and Muñoz, A. (2007).  Parametric
survival analysis and taxonomy of hazard functions for the generalized
gamma distribution.  Statistics in Medicine 26:4252-4374
}
\keyword{package}

