% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc_convert.R
\name{pandoc_convert}
\alias{pandoc_convert}
\title{Convert a \code{Pandoc} File}
\usage{
pandoc_convert(
  file,
  text = NULL,
  from = pandoc_input_formats(),
  to = pandoc_output_formats()
)
}
\arguments{
\item{file}{file to read}

\item{text}{string to use instead of file if set}

\item{from}{input format}

\item{to}{output format}
}
\value{
the converted text
}
\description{
Convert a \code{Pandoc} File
}
\examples{
if (rmarkdown::pandoc_available()) {
  x <- pandoc_convert(
      text = "\\\\section{Test}", from = "latex", to = "markdown")
  stopifnot(identical(x, "Test\n====") || identical(x, "# Test"))
}
}
