% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_predict.R
\name{predict.modeler}
\alias{predict.modeler}
\title{Predict an object of class \code{modeler}}
\usage{
\method{predict}{modeler}(
  object,
  x = NULL,
  id = NULL,
  type = c("point", "auc", "fd", "sd"),
  se_interval = c("confidence", "prediction"),
  n_points = 1000,
  formula = NULL,
  metadata = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{modeler}, typically the result of calling
the \code{modeler()} function.}

\item{x}{A numeric value or vector specifying the points at which predictions
are made. For \code{type = "auc"}, \code{x} must be a vector of length 2 that
specifies the interval over which to calculate the AUC.}

\item{id}{Optional unique identifier to filter predictions by a specific group. Default is \code{NULL}.}

\item{type}{A character string specifying the type of prediction. Default is "point".
\describe{
  \item{\code{"point"}}{Predicts the value of \code{y} for the given \code{x}.}
  \item{\code{"auc"}}{Calculates the area under the curve (AUC) for the fitted model over the interval specified by \code{x}.}
  \item{\code{"fd"}}{Returns the first derivative (rate of change) of the model at the given \code{x} value(s).}
  \item{\code{"sd"}}{Returns the second derivative of the model at the given \code{x} value(s).}
}}

\item{se_interval}{A character string specifying the type of interval for
standard error calculation. Options are \code{"confidence"} (default) or
\code{"prediction"}. Only works with "point" estimation.}

\item{n_points}{An integer specifying the number of points used to approximate
the area under the curve (AUC) when \code{type = "auc"}. Default is \code{1000}.}

\item{formula}{A formula specifying a function of the parameters to be estimated (e.g., \code{~ b * 500}). Default is \code{NULL}.}

\item{metadata}{Logical. If \code{TRUE}, metadata is included with the
predictions. Default is \code{FALSE}.}

\item{...}{Additional parameters for future functionality.}
}
\value{
A \code{data.frame} containing the predicted values,
their associated standard errors, and optionally the metadata.
}
\description{
Generate model predictions from an object of class \code{modeler}.
This function allows for flexible prediction types, including point predictions,
area under the curve (AUC), first or second order derivatives, and functions
of the parameters.
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_linear_sat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(15, 2, 45)
  )
print(mod_1)
# Point Prediction
predict(mod_1, x = 45, type = "point", id = 2)
# AUC Prediction
predict(mod_1, x = c(0, 108), type = "auc", id = 2)
# First Derivative
predict(mod_1, x = 45, type = "fd", id = 2)
# Second Derivative
predict(mod_1, x = 45, type = "sd", id = 2)
# Function of the parameters
predict(mod_1, formula = ~ t2 - t1, id = 2)
}
\author{
Johan Aparicio [aut]
}
