% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{rhats}
\alias{rhats}
\title{Calculate and Print Rhat Diagnostics for rjMCMC Results}
\usage{
rhats(results)
}
\arguments{
\item{results}{An \code{rjMCMC} object, including:
\describe{
\item{trt_eff_posterior}{Matrix of posterior treatment effects.}
\item{inter_trt_param}{Matrix of posterior estimates for intercept and main treatment effect.}
}}
}
\value{
A list containing:
\describe{
\item{Rhat_trt_eff_posterior}{Vector of R-hat values for each individual's treatment effect.}
\item{Rhat_inter}{R-hat value for the intercept parameter.}
\item{Rhat_trt}{R-hat value for the main effect of treatment.}
}
}
\description{
This function calculates the Rhat diagnostic for convergence based on the posterior samples
of individual treatment effects, intercept, and main treatment effect from an rjMCMC model.
It prints the median, minimum, and maximum Rhat values for the treatment effects, as well as
the Rhat for the intercept and treatment effect.
}
\details{
This function calculates R-hat statistics to assess MCMC convergence for both treatment effects and model parameters.
Diagnostic plots are generated to visually inspect the chains across iterations.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)

mcmc_specs <- list(B = 2000, burnin = 1000, thin = 1, chains = 2, sigma_v = 0.1, bma = TRUE)
prior_params <- list(lambda_1 = 0.1, lambda_2 = 1, a_0 = 0.01, b_0 = 0.01,
                  degree = 3, k_max = 9, w = 1, sigma_B = sqrt(20))

results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  mcmc_specs, prior_params)
rhats(results)
}
}
