% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscfuns.R
\name{setFixest_multi}
\alias{setFixest_multi}
\alias{getFixest_multi}
\title{Sets properties of \code{fixest_multi} objects}
\usage{
setFixest_multi(drop = FALSE)

getFixest_multi()
}
\arguments{
\item{drop}{Logical scalar, default is \code{FALSE}. Provides the default value of the argument
\code{drop} when subsetting \code{fixest_multi} objects.}
}
\value{
The function \code{getFixest_multi()} returns the list of settings.
}
\description{
Use this function to change the default behavior of \code{fixest_multi} objects.
}
\examples{

# 1) let's run a multiple estimation
base = setNames(iris, c("y", "x1", "x2", "x3", "species"))
est = feols(y ~ csw(x1, x2, x3), base)

# 2) let's pick a single estimation => by default we have a `fixest_multi` object
class(est[rhs = 2])

# `drop = TRUE` would have led to a `fixest` object
class(est[rhs = 2, drop = TRUE])

# 3) change the default behavior
setFixest_multi(drop = TRUE)
class(est[rhs = 2])


}
