% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latest.R
\name{fixer_latest}
\alias{fixer_latest}
\title{Latest exchange rates}
\usage{
fixer_latest(base = "EUR", symbols = NULL)
}
\arguments{
\item{base}{The base currency to index other currencies against. Defaults
to \code{"EUR"}. Other base currencies are only available on paid plans.}

\item{symbols}{A character vector of the symbols of currencies to return
exchange rates for, or a string for a single currency. Defaults to
\code{NULL} and returns all available currencies. See
\code{\link{fixer_symbols}} for details on symbol options.}
}
\value{
A tibble with the latest available currency exchange data.
}
\description{
Returns a tibble with the most recently available currency
conversion data available from the Fixer API.
}
\examples{
\dontrun{

today <- fixer_latest()

today_usd <- fixer_latest(base = "USD")

today_symbols <- fixer_latest(base = "USD",
                              symbols = c("EUR", "JPY", "CAD"))

}
}
