% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotratecurve-interpolation.R
\name{fit_interpolation}
\alias{fit_interpolation}
\alias{fit_interpolation,NelsonSiegel,SpotRateCurve-method}
\alias{fit_interpolation,NelsonSiegelSvensson,SpotRateCurve-method}
\title{Fit parametric interpolation functions}
\usage{
fit_interpolation(object, x, ...)
}
\arguments{
\item{object}{a Interpolation object with initial parameters set.}

\item{x}{a SpotRateCurve object.}

\item{...}{additional arguments. Currently unused.}
}
\value{
A \code{Interpolation} object.
}
\description{
Fits parametric interpolation functions like \linkS4class{NelsonSiegel} or
\linkS4class{NelsonSiegelSvensson}.
}
\examples{
terms <- c(1, 11, 26, 27, 28)
rates <- c(0.0719, 0.056, 0.0674, 0.0687, 0.07)
curve <- spotratecurve(rates, terms, "discrete", "actual/365", "actual")
fit_interpolation(interp_nelsonsiegel(0.1, 0.01, 0.01, 0.01), curve)
}
