% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolism.R
\name{metabolism}
\alias{metabolism}
\title{A function to estimate f0 and alpha}
\usage{
metabolism(family, temp, troph_m, troph_sd = 1e-10)
}
\arguments{
\item{family}{family fish}

\item{temp}{Temperature in degrees Celsius}

\item{troph_m}{Trophic level mean (from 1 to 5)}

\item{troph_sd}{Trophic level sd (optional)}
}
\value{
dataframe with predicted metabolic parameters.
}
\description{
All model parameters below were estimated by Barneche & Allen 2018 Ecology
Letters doi: 10.1111/ele.12947. These parameters are for the best model
(Model 2 in the paper online supplementary material) of fish resting
metabolic rates reported in the paper, which also includes trophic level as
a covariate.
}
\details{
All model parameters below were estimated by 
Barneche & Allen 2018 Ecology Letters doi: 10.1111/ele.12947. 
These parameters are for the best model 
(Model 2 in the paper online supplementary material) 
of fish resting metabolic rates reported in the paper, 
which also includes trophic level as a covariate.
}
\examples{
library(fishflux)
metabolism(family = "Pomacentridae", temp = 27, troph_m = 2)

}
\keyword{Fish}
\keyword{metabolism}
