% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sign_in_anonymously.R
\name{sign_in_anonymously}
\alias{sign_in_anonymously}
\title{Sign in a user anonymously}
\usage{
sign_in_anonymously()
}
\value{
A named list with the following items:
\itemize{
\item \code{idToken}: A Firebase Auth ID token for the newly created user.
\item \code{email}: Since the user is anonymous, this should be empty.
\item \code{refreshToken}: A Firebase Auth refresh token for the newly created user.
\item \code{expiresIn}: The number of seconds in which the ID token expires.
\item \code{localId}: The uid of the newly created user.
\item \code{error}:
\itemize{
\item \code{NULL} if no error code in response
\item A list of 2 if response was an error:
\itemize{
\item \code{code}: Error code
\item \code{message}: Error message
}
}
}
}
\description{
Sign in a user anonymously
}
\details{
To use sign in users anonymously, you must first enable the
Anonymous sign in method in your firebase project.

Go to \href{https://console.firebase.google.com}{Firebase console} and check your
\emph{Sign-in} providers under the \emph{Sign-in Methods} tab in the \emph{Authentication}
service and make sure \emph{Anonymous} is enabled.

Visit \href{https://firebase.google.com/docs/reference/rest/auth#section-sign-in-anonymously}{Firebase Auth REST API docs}
for more details.
}
\examples{
\dontrun{
  user <- sign_in_anonymously()
  user
}
}
